*-----------------------------------------------------------
* Program    :
* Written by :
* Date       :
* Description: Mov - Predefineds intended to make 
*	       hand assembling various 68K instructions in
*	       code function bodies easier.
*-----------------------------------------------------------
*
MOVL	equ	$2000
MOVW	equ	$3000
MOVB	equ	$1000
*
*	Addressing Modes
*
DD	equ	0
AD	equ	1
AI	equ	2
APL	equ	3
MNA	equ	4
AWD	equ	5
AXB	equ	6
PCR	equ	7
ABSW	equ	0
ABS	equ	1
PCWD	equ	2
PCXB	equ	3
PCIM	equ	4
*
*	============== Movel(dstreg,dstmode,srcmode,srcreg) ===========
*	Immediate Word(s) and Extension word(s)to be built
*	and pushed afterwards as required.
*	Assemble the instruction on the stack
	OFFSET	0

_mvlResult	DS.L	1
_mvlPrvFrm	DS.L	1
_mvldstreg	DS.L	1
_mvldstmode	DS.L	1
_mvlsrcmode	DS.L	1
_mvlsrcreg	DS.L	1
_mvlimmedlo	DS.L	1
_mvlimmedhi	DS.L	1
_mvlsext	DS.L	1
_mvldext	DS.L	1
_mvlRetPC	DS.L	1
	ORG	*
*	====================== Movel =====================================
Movel:	
	move.l	#MOVL,d0		* Opcode
move2:
	move.l	(a7)+,a0		* RetPC
	move.l	-_mvldstreg(a6),d1	* dstreg
	lsl.l	#1,d1			* align
	lsl.l	#8,d1			* finish align 
	or.l	d1,d0			* merge
	move.l	-_mvldstmode(a6),d1	* dstmode
	lsl.l	#6,d1			* align
	or.l	d1,d0			* merge
	move.l	-_mvlsrcmode(a6),d1	* srcmode
	lsl.l	#3,d1			* align
	or.l	d1,d0			* merge
	move.l	-_mvlsrcreg(a6),d1	* srcreg
	or.l	d1,d0			* merge
	move.l	d0,(a6)
	jmp	(a0)
*
*	===================== Movw =============================
Movew:	
	move.l	#MOVW,d0		* opcode
	bra	move2
*
*	===================== Movb =============================
*
Moveb:
	move.l	#MOVB,d0		* opcode
	bra	move2
*
*	======= EffAddrExtWd(dreg:bool,reg:0-7,word:bool,d8:byte):word ===
	OFFSET	0
_eaxwResult	DS.L	1
_eaxwPrvFrm	DS.L	1
_eaxwdreg	DS.L	1
_eaxwreg	DS.L	1
_eaxwlong	DS.L	1
_eaxwd8		DS.L	1
	ORG	*
EffAddrExtWd:
	move.l	(a7)+,a0
	clr.l	d0
	tst.l	-_eaxwdreg(a6)
	beq	eaxwareg
	ori.w	#$8000,d0		* d/a reg
eaxwareg:
	move.l	-_eaxwreg(a6),d1	* reg
	lsl.l	#3,d1			* align
	lsl.l	#8,d1			* finish align
	or.w	d1,d0
	tst.l	-_eaxwlong(a6)
	beq	eaxd8
	ori.w	#$0800,d0		* w=0,l=1
eaxd8:
	move.l	-_eaxwd8(a6),d1
	or.b	d1,d0
	move.l	d0,(a6)
	jmp	(a0)
*
	ORG	(*+3)&-4
*
*	=============================== Name Vectors ====================
*
_DD:	DC.L	_WrdSwap
	DC.W	8
	DC.W	2
	DC.B	'_D',0,0,0,0,0,0
_AD:	DC.L	_DD
	DC.W	8
	DC.W	2
	DC.B	'_A',0,0,0,0,0,0
_AI:	DC.L	_AD
	DC.W	8
	DC.W	2
	DC.B	'_I',0,0,0,0,0,0
_APL:	DC.L	_AI
	DC.W	8
	DC.W	3
	DC.B	'_I+',0,0,0,0,0
_MNA:	DC.L	_APL
	DC.W	8
	DC.W	3
	DC.B	'_-I',0,0,0,0,0
_AWD:	DC.L	_MNA
	DC.W	8
	DC.W	4
	DC.B	'_I+W',0,0,0,0
_AXB:	DC.L	_AWD
	DC.W	8
	DC.W	5
	DC.B	'_IX+B',0,0,0
_PCR:	DC.L	_AXB
	DC.W	8
	DC.W	3
	DC.B	'_PC',0,0,0,0,0
_ABSW:	DC.L	_PCR
	DC.W	8
	DC.W	5
	DC.B	'_ABSW',0,0,0
_ABS:	DC.L	_ABSW
	DC.W	8
	DC.W	4
	DC.B	'_ABS',0,0,0,0
_PCWD:	DC.L	_ABS
	DC.W	8
	DC.W	5
	DC.B	'_PC+W',0,0,0
_PCXB:	DC.L	_PCWD
	DC.W	8
	DC.W	6
	DC.B	'_PCX+B',0,0
_PCIM:	DC.L	_PCXB
	DC.W	8
	DC.W	4
	DC.B	'_IMM',0,0,0,0
*
_Movel:	DC.L	_PCIM
	DC.W	8
	DC.W	6
	DC.B	'_Movel',0,0
*
_Movew:	DC.L	_Movel
	DC.W	8
	DC.W	6
	DC.B	'_Movew',0,0
*
_Moveb:	DC.L	_Movew
	DC.W	8
	DC.W	6
	DC.B	'_Moveb',0,0

*
_EAXW:	DC.L	_Moveb
	DC.W	8
	DC.W	5
	DC.B	'_EAXW',0,0,0
*
*	==================== Dic Entries ======================
*
__DD:	DC.L	__WrdSwap
	DC.L	_DD
	DC.L	DD
__AD:	DC.L	__DD
	DC.L	_AD
	DC.L	AD
__AI:	DC.L	__AD
	DC.L	_AI
	DC.L	AI
__APL:	DC.L	__AI
	DC.L	_APL
	DC.L	APL
__MNA:	DC.L	__APL
	DC.L	_MNA
	DC.L	MNA
__AWD:	DC.L	__MNA
	DC.L	_AWD
	DC.L	AWD
__AXB:	DC.L	__AWD
	DC.L	_AXB
	DC.L	AXB
__PCR:	DC.L	__AXB
	DC.L	_PCR
	DC.L	PCR
__ABSW:	DC.L	__PCR
	DC.L	_ABSW
	DC.L	ABSW
__ABS:	DC.L	__ABSW
	DC.L	_ABS
	DC.L	ABS
__PCWD:	DC.L	__ABS
	DC.L	_PCWD
	DC.L	PCWD
__PCXB:	DC.L	__PCWD
	DC.L	_PCXB
	DC.L	PCXB
__PCIM:	DC.L	__PCXB
	DC.L	_PCIM
	DC.L	PCIM
*
__Movel:	DC.L	__PCIM
		DC.L	_Movel
		DC.L	Movel
__Movew:	DC.L	__Movel
		DC.L	_Movew
		DC.L	Movew
__Moveb:	DC.L	__Movew
		DC.L	_Moveb
		DC.L	Moveb
__EAXW:		DC.L	__Moveb
		DC.L	_EAXW
		DC.L	EffAddrExtWd
*	













*~Font name~Courier New~
*~Font size~10~
*~Tab type~1~
*~Tab size~8~
